# HarmonyOS Next 验证码WebView接入示例

本项目演示了如何在HarmonyOS Next原生应用中使用WebView组件接入阿里云验证码2.0服务。

## 项目概述

基于阿里云验证码2.0的Android WebView接入方案，使用ArkTS语言开发的HarmonyOS Next原生应用Demo。

## 快速开始

### 环境要求

1. **开发工具**: DevEco Studio 5.0.3.403 或更高版本
2. **SDK**: HarmonyOS NEXT Developer Beta1 或更高版本 (API 12)
3. **设备**: 支持HarmonyOS NEXT的设备或模拟器
4. **网络**: 需要能够访问阿里云验证码服务

### 调试和测试

#### 1. 查看日志

```bash
# 查看应用日志
hdc shell hilog | grep -i captcha

# 查看WebView日志
hdc shell hilog | grep -i webview
```

#### 2. 调试WebView

在DevEco Studio中：

1. 连接设备并运行应用
2. 打开 `View → Tool Windows → HiLog`
3. 筛选应用包名的日志
4. 观察WebView和JavaScript的交互日志

#### 3. 网络调试

如果验证码无法正常加载：

1. 检查设备网络连接
2. 确认阿里云验证码服务配置正确
3. 检查防火墙和代理设置

## 核心功能说明

### WebView组件配置

```typescript
Web({ src: $rawfile('captcha.html'), controller: this.webviewController })
  .javaScriptAccess(true)           // 启用JavaScript
  .domStorageAccess(true)           // 启用DOM存储
  .onlineImageAccess(true)          // 允许在线图片
  .imageAccess(true)                // 启用图片访问
  .mixedMode(MixedMode.All)         // 允许混合内容
  .cacheMode(CacheMode.None)        // 禁用缓存确保验证码更新
```

### JavaScript桥接

```typescript
class JSInterface {
  getCaptchaVerifyParam(captchaVerifyParam: string): void {
    // 处理验证码验签参数
    const params = JSON.parse(captchaVerifyParam);
    // 发送到后端进行验签...
  }
}

// 注册JavaScript接口
this.webviewController.registerJavaScriptProxy(
  this.jsInterface,
  "testInterface",
  ["getCaptchaVerifyParam"]
);
```

### HTML页面调用

```javascript
// 验证成功后调用原生接口
function success(captchaVerifyParam) {
  window.testInterface && 
  window.testInterface.getCaptchaVerifyParam(captchaVerifyParam);
}
```

## 📚 相关文档

- [HarmonyOS应用开发官方文档](https://developer.huawei.com/consumer/cn/doc/harmonyos-guides/application-dev-guide)
- [阿里云验证码2.0文档](https://help.aliyun.com/document_detail/121394.html)
- [ArkTS语言参考](https://developer.huawei.com/consumer/cn/doc/harmonyos-guides/arkts-get-started)
- [WebView组件开发指南](https://developer.huawei.com/consumer/cn/doc/harmonyos-references/ts-basic-components-web)
